<?php
global $post;

$form_settings       = get_post_meta( $post->ID, 'wpuf_form_settings', true );

$enable_convertkit   = isset( $form_settings['enable_convertkit'] ) ? $form_settings['enable_convertkit'] : 'no';
$list_selected       = isset( $form_settings['convertkit_list'] ) ? $form_settings['convertkit_list'] : '';
?>

<table class="form-table">

    <tr class="wpuf-post-type">
        <th><?php _e( 'Enable ConvertKit', 'wpuf-pro' ); ?></th>
        <td>
            <input type="checkbox" id="enable_convertkit" name="wpuf_settings[enable_convertkit]" value="yes" <?php echo ($enable_convertkit=='yes') ? 'checked': '' ?> > <label for="enable_convertkit"><?php  _e( 'Enable ConvertKit', 'wpuf-pro' ) ?></label>
        </td>
    </tr>

    <tr class="wpuf-redirect-to">
        <th><?php _e( 'Select Preferred List', 'wpuf-pro' ); ?></th>
        <td>
            <?php $lists = get_option( 'wpuf_ck_lists');
                if ( $lists ) { ?>
                <select name="wpuf_settings[convertkit_list]">
                    <?php foreach ( $lists as $key => $value) {
                        printf('<option value="%s"%s>%s</option>', $value['id'], selected( $list_selected, $value['id'], false ), $value['name'] );
                    } ?>
                </select>

                <div class="description">
                    <?php _e( 'Select your convertkit list for subscriptions', 'wpuf-pro' ) ?>
                </div>

            <?php } else {
                    _e( 'You are not connected with convertkit. Insert your API key first', 'wpuf-pro' );
            } ?>
        </td>
    </tr>
</table>
